#{{uc_id}}
{
  text-align:{{alignment}};
}

#{{uc_id}} a {
  padding: 0.7em calc(0.7em * 1.2);
  display: inline-block;
  border: {{border_width}}px solid transparent;
  position: relative;
  cursor: pointer;
  text-decoration:none;
}
#{{uc_id}} a .text {
  transform: translate3d(0, 0.7em, 0);
  display: block;
  transition: transform 0.4s cubic-bezier(0.2, 0, 0, 1) 0.4s;
}
#{{uc_id}} a:after {
  position: absolute;
  content: '';
  bottom: -{{border_width}}px;
  left: calc(0.7em * 1.2);
  right: calc(0.7em * 1.2);
  height: {{border_width}}px;
  background: {{brdr_clr}};
  transition: transform 0.8s cubic-bezier(1, 0, 0.37, 1) 0.2s, right 0.2s cubic-bezier(0.04, 0.48, 0, 1) 0.6s, left 0.4s cubic-bezier(0.04, 0.48, 0, 1) 0.6s;
  transform-origin: left;
}
#{{uc_id}} .line {
  position: absolute;
  background: {{brdr_clr}};
}
#{{uc_id}} .line.-right, #{{uc_id}} .line.-left {
  width: {{border_width}}px;
  bottom: -{{border_width}}px;
  top: -{{border_width}}px;
  transform: scale3d(1, 0, 1);
}
#{{uc_id}} .line.-top, #{{uc_id}} .line.-bottom {
  height: {{border_width}}px;
  left: -{{border_width}}px;
  right: -{{border_width}}px;
  transform: scale3d(0, 1, 1);
}
#{{uc_id}} .line.-right {
  right: -{{border_width}}px;
  transition: transform 0.1s cubic-bezier(1, 0, 0.65, 1.01) 0.23s;
  transform-origin: top;
}
#{{uc_id}} .line.-top {
  top: -{{border_width}}px;
  transition: transform 0.08s linear 0.43s;
  transform-origin: left;
}
#{{uc_id}} .line.-left {
  left: -{{border_width}}px;
  transition: transform 0.08s linear 0.51s;
  transform-origin: bottom;
}
#{{uc_id}} .line.-bottom {
  bottom: -{{border_width}}px;
  transition: transform 0.3s cubic-bezier(1, 0, 0.65, 1.01);
  transform-origin: right;
}
#{{uc_id}} a:hover .text,
#{{uc_id}} a:active .text {
  transform: translate3d(0, 0, 0);
  transition: transform 0.6s cubic-bezier(0.2, 0, 0, 1) 0.4s;
}
#{{uc_id}} a:hover:after,
#{{uc_id}} a:active:after {
  transform: scale3d(0, 1, 1);
  right: -{{border_width}}px;
  left: -{{border_width}}px;
  transform-origin: right;
  transition: transform 0.2s cubic-bezier(1, 0, 0.65, 1.01) 0.17s, right 0.2s cubic-bezier(1, 0, 0.65, 1.01), left 0s 0.3s;
}
#{{uc_id}} a:hover .line,
#{{uc_id}} a:active .line {
  transform: scale3d(1, 1, 1);
}
#{{uc_id}} a:hover .line.-right,
#{{uc_id}} a:active .line.-right {
  transition: transform 0.1s cubic-bezier(1, 0, 0.65, 1.01) 0.2s;
  transform-origin: bottom;
}
#{{uc_id}} a:hover .line.-top,
#{{uc_id}} a:active .line.-top {
  transition: transform 0.08s linear 0.4s;
  transform-origin: right;
}
#{{uc_id}} a:hover .line.-left,
#{{uc_id}} a:active .line.-left {
  transition: transform 0.08s linear 0.48s;
  transform-origin: top;
}
#{{uc_id}} a:hover .line.-bottom,
#{{uc_id}} a:active .line.-bottom {
  transition: transform 0.5s cubic-bezier(0, 0.53, 0.29, 1) 0.56s;
  transform-origin: left;
}